function File = displacement_finder(Settings,File)

% DISPLACEMENT FINDER performs a PIV analysis. It computes the displacement
% field of the gel compared to the reference image. 
%
%   Robert Steward 2011
%   Xavier Trepat 21-09-07
%   Raimon Sunyer 11-01-06
%	Iva Marija Tolic-Norrelykke 03-21-01


% Change directory
cd([File.pathname,'croppeddata']);

for ifile = 1:(File.NFiles.Fluorescence), %par for parallel processing
    disp(['Computing Displacements of ',File.Name(ifile).CropFluorescence])
   

     im1 = double(imread([File.Name(1).CropTrypsin]));   
     im2 = double(imread([File.Name(ifile).CropFluorescence])); 


    
     [x,y,dx,dy,pkh] = disp_on_blocks_fast(  im1, ... % reference image
                                             im2, ... % measurement image
                                             Settings.resolution, ... % resolution of the PIV grid
                                             Settings.overlap, ... % overlap between blocks
                                             Settings.resolution, ... % padding for the PIV, usually 0
                                            'hanning', ... % window
                                            '2DCentroid', ...
                                             0, ... % threshold of center of mass calculation
                                             1, ... % Size of the window
                                             4 ... % number of iterations
                                            );
               
            
    % Save displacements
    xv  	= 	mat2vertcol(x);
    yv  	= 	mat2vertcol(y);
    uxv 	= 	mat2vertcol(dx);
    uyv 	= 	mat2vertcol(dy);
    pkh     =   mat2vertcol(pkh); %not saved
    
    File.Name(ifile).Displacements =[File.pathname '/Displacements','/', 'GelDisp_', num2str(ifile), '.dat'];


    %set file name and location for displacements
          f3 = fopen([File.pathname '/Displacements','/', 'GelDisp_', num2str(ifile), '.dat'],'w');
   %end

   %save x, y, ux, and uy. Note cross-correlation peak is not being saved
    for i = 1:size(uxv,1),
        fprintf(f3,'%15.5e%15.5e%15.5e%15.5e\n', xv(i), yv(i), uxv(i), uyv(i));
    end
    fclose(f3);   
 
end    
